package com.ysscale.framework.em.socket;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: DeviceFuncationEnum
 * @projectName ysscale-core
 * @description: 设备功能枚举
 * @date 2019/5/1521:40
 */
public enum DeviceConfigEnum {

    日志("0", "日志"),
    云支付("1", "云支付"),
    吉卡云("2", "吉卡云"),
    厂部发卡("3", "厂部发卡"),
    吉卡云充值("4", "吉卡云充值"),
    第三方配置("5", "第三方配置"),
    知鲜到商城("6", "知鲜到商城"),
    商城订单服务器通知("7", "商城订单服务器通知"),
    设备锁定("8", "设备锁定"),
    传感器("9", "传感器"),
    AI功能("10", "AI功能"),


    设备使用超时时间("201", "设备使用超时时间"),
    设备使用范围("202", "设备使用范围（公里）"),;

    private String type;

    private String name;

    DeviceConfigEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }

    /**
     * @description: 获取设备类型
     **/
    public static DeviceConfigEnum config(String type) {
        if (StringUtils.isNotBlank(type)) {
            for (DeviceConfigEnum deviceConfigEnum : DeviceConfigEnum.values()) {
                if (type.equals(deviceConfigEnum.getType())) return deviceConfigEnum;
            }
        }
        return null;
    }

    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return this.type;
    }
}
