package com.ysscale.framework.em.socket;

import java.util.Objects;

/**
 * @author lie_w
 * @title: DeviceInitType
 * @projectName ysscale_core
 * @description: TODO
 * @date 2022/4/2616:22
 */
public enum DeviceInitType {

    USE(0, "使用中"),
    INIT_FACTORY(1, "出厂");

    private Integer type;

    private String description;

    DeviceInitType(Integer type, String description) {
        this.type = type;
        this.description = description;
    }

    public static DeviceInitType initType(Integer initType) {
        if (Objects.nonNull(initType)) {
            for (DeviceInitType deviceInitType : DeviceInitType.values()) {
                if (initType.equals(deviceInitType.getType())) return deviceInitType;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }
}
