package com.ysscale.mongo.config;

import com.mongodb.MongoClientURI;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

/**
 * @ClassName: AbstractMongoConfig
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2018/12/24 22:38
 * @Version: V1.0.0
 */
@Configuration
public abstract class AbstractMongoConfig {

    private String uri;

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public MongoDbFactory mongoDbFactory() throws Exception {
        return new SimpleMongoDbFactory(new MongoClientURI(uri));
    }

    abstract public MongoTemplate getMongoTemplate() throws Exception;
}
