package com.ysscale.mongo.dao;

import com.ysscale.framework.model.page.Page;
import com.ysscale.framework.model.page.PageQuery;
import com.ysscale.mongo.entity.MongoEntity;
import org.springframework.data.mongodb.core.query.Query;

import java.util.List;

/**
 * Created by yuliang on 2017/4/17.
 */
public interface MongoBaseDao<T extends MongoEntity> {

    void saveOrUpdate(T t);

    void saveOrUpdate(T t, String tableName);

    List<T> findAll();

    List<T> findAll(String tableName);

    Page<T> pageForBeanList(Query query, int nowPage, int pageSize);

    Page<T> pageForBeanList(Query query, int nowPage, int pageSize, String tableName);

    void remove(T t);

    void remove(T t, String tableName);

    void dropTable();

    void dropTable(String tableName);

    Page<T> pageForBeanPage(Query query, PageQuery pageQuery);

    Page<T> pageForBeanPage(Query query, PageQuery pageQuery, String tableName);

    List<T> pageForBeanList(Query query, PageQuery pageQuery);

    List<T> pageForBeanList(Query query, PageQuery pageQuery, String tableName);

}
