package com.ysscale.mongo.dao.impl;


import com.ysscale.framework.model.page.Page;
import com.ysscale.framework.model.page.PageQuery;
import com.ysscale.mongo.dao.MongoBaseDao;
import com.ysscale.mongo.entity.MongoEntity;
import com.ysscale.mongo.utils.MongoPageable;
import com.ysscale.mongo.utils.PackageMongoPageInfo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by yuliang on 2016/3/23.
 */
public abstract class MongoBaseDaoImpl<T extends MongoEntity> implements MongoBaseDao<T> {


    @Autowired
    protected MongoTemplate mongoTemplate;

    protected Class clazz;

    public MongoBaseDaoImpl() {
        this.clazz = (Class<?>) ((ParameterizedType) getClass()
                .getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public void saveOrUpdate(T t) {
        mongoTemplate.save(t);
    }

    public List<T> findAll() {
        Query query = new Query();
        return mongoTemplate.find(query, clazz);
    }

    @Override
    public void saveOrUpdate(T t, String tableName) {
        mongoTemplate.save(t, tableName);
    }

    @Override
    public List<T> findAll(String tableName) {
        Query query = new Query();
        return mongoTemplate.find(query, clazz, tableName);
    }

    @Override
    public Page<T> pageForBeanList(Query query, int nowPage, int pageSize) {
        return pageForBeanList(query, nowPage, pageSize, null);
    }

    @Override
    public Page<T> pageForBeanList(Query query, int nowPage, int pageSize, String tableName) {
        Page<T> page = new Page<T>();
        long count;
        if (StringUtils.isEmpty(tableName)) {
            count = mongoTemplate.count(query, clazz);
        } else {
            count = mongoTemplate.count(query, clazz, tableName);
        }
        page.setTotal((int) count);

        Pageable pageable = new PageRequest(nowPage - 1, pageSize);
        query.with(pageable);
        List<T> list;
        if (StringUtils.isEmpty(tableName)) {
            list = mongoTemplate.find(query, clazz);
        } else {
            list = mongoTemplate.find(query, clazz, tableName);
        }
        page.setRows(list);
        page.setNowPage(nowPage);
        page.setPageSize(pageSize);

        long pageNumber = 0;
        if (count > 0) {
            if (count % pageSize == 0) {
                pageNumber = count / pageSize;
            } else {
                pageNumber = count / pageSize + 1;
            }
        }
        page.setPageNumber((int) pageNumber);
        return page;
    }

    @Override
    public Page<T> pageForBeanPage(Query query, PageQuery pageQuery) {
        return pageForBeanPage(query, pageQuery, null);
    }

    @Override
    public Page<T> pageForBeanPage(Query query, PageQuery pageQuery, String tableName) {
        long count;
        if (StringUtils.isEmpty(tableName)) {
            count = mongoTemplate.count(query, clazz);
        } else {
            count = mongoTemplate.count(query, clazz, tableName);
        }

        if (count == 0) {
            return PackageMongoPageInfo.empty();
        }

        MongoPageable pageable = new MongoPageable(pageQuery, count);

        List<T> list = new ArrayList<>();
        if (StringUtils.isBlank(tableName)) {
            list = mongoTemplate.find(query.with(pageable), clazz);
        } else {
            list = mongoTemplate.find(query.with(pageable), clazz, tableName);
        }
        return PackageMongoPageInfo.packageInfo(list, pageable, count);
    }

    @Override
    public List<T> pageForBeanList(Query query, PageQuery pageQuery) {
        return pageForBeanList(query, pageQuery, null);
    }

    @Override
    public List<T> pageForBeanList(Query query, PageQuery pageQuery, String tableName) {
        MongoPageable pageable = new MongoPageable(pageQuery);
        List<T> list = new ArrayList<>();
        if (StringUtils.isBlank(tableName)) {
            list = mongoTemplate.find(query.with(pageable), clazz);
        } else {
            list = mongoTemplate.find(query.with(pageable), clazz, tableName);
        }
        return list;
    }

    @Override
    public void remove(T t) {
        mongoTemplate.remove(t);
    }

    @Override
    public void remove(T t, String tableName) {
        mongoTemplate.remove(t, tableName);
    }

    @Override
    public void dropTable() {
        mongoTemplate.dropCollection(clazz);
    }


    @Override
    public void dropTable(String tableName) {
        mongoTemplate.dropCollection(tableName);
    }
}
