package com.ysscale.mongo.utils;

import com.ysscale.framework.model.page.PageQuery;
import com.ysscale.mongo.constant.MongoConstant;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName: MongoPageable
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/2/13 17:46
 * @Version: V1.0.0
 */
public class MongoPageable implements Serializable, Pageable {

    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPageable.class);

    private PageQuery pageQuery;

    private long count;

    public MongoPageable(PageQuery pageQuery) {
        this.pageQuery = pageQuery;
    }

    public MongoPageable(PageQuery pageQuery, long count) {
        this.pageQuery = pageQuery;
        this.count = count;
    }

    @Override
    public int getPageNumber() {
        return (int) ((count - 1) / pageQuery.getLimit() + 1);
    }

    @Override
    public int getPageSize() {
        return pageQuery.getLimit();
    }

    @Override
    public long getOffset() {
        if (pageQuery.getPage() != 0) {
            return (pageQuery.getPage() - 1) * pageQuery.getLimit();
        }
        return pageQuery.getOffset();
    }

    public int getNowPage() {
        if (pageQuery.getPage() != 0) {
            return pageQuery.getPage();
        }
        if (pageQuery.getOffset() != 0) {
            return pageQuery.getOffset() / pageQuery.getLimit() + 1;
        }
        return 1;
    }

    @Override
    public Sort getSort() {
        String orderStr = pageQuery.getOrder();
        List<Sort.Order> orders = new ArrayList<>();
        if (StringUtils.isNotBlank(orderStr)) {
            String[] orderParts = orderStr.split(",");
            if (orderParts != null && orderParts.length != 0) {
                for (String orderPart : orderParts) {
                    String[] orderPar = orderPart.split(" ");
                    if (orderPar != null && orderPar.length == 2) {
                        Sort.Order order = null;
                        if (MongoConstant.DESC.equalsIgnoreCase(orderPar[1])) {
                            order = new Sort.Order(Sort.Direction.DESC, orderPar[0]);
                        } else if (MongoConstant.ASC.equalsIgnoreCase(orderPar[1])) {
                            order = new Sort.Order(Sort.Direction.ASC, orderPar[0]);
                        } else {
                            LOGGER.error(orderPart + "排序格式错误");
                            continue;
                        }
                        orders.add(order);
                    } else {
                        LOGGER.error(orderPart + "排序格式错误");
                        continue;
                    }
                }
            }
        }
        return new Sort(orders);
    }

    @Override
    public Pageable next() {
        return null;
    }

    @Override
    public Pageable previousOrFirst() {
        return null;
    }

    @Override
    public Pageable first() {
        return null;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }
}
