package com.ysscale.mongo.utils;

import com.ysscale.framework.model.page.Page;
import com.ysscale.mongo.entity.MongoEntity;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * @ClassName: PackageMongoPageInfo
 * @Desprition: Mongo分页封装
 * @Auth: lie_w
 * @Date: 2019/2/13 18:51
 * @Version: V1.0.0
 */
public class PackageMongoPageInfo {

    private PackageMongoPageInfo() {
    }

    public static <T extends MongoEntity> Page<T> packageInfo(List<T> list, MongoPageable pageable, long count) {
        PageImpl<T> pageList = new PageImpl<>(list, pageable, count);
        Page<T> page = new Page<>();
        page.setTotal(pageList.getTotalElements());
        page.setPageSize(pageable.getPageSize());
        page.setPageNumber(pageable.getPageNumber());
        page.setRows(pageList.getContent());
        page.setNowPage(pageable.getNowPage());
        return page;
    }

    public static <T extends MongoEntity> Page<T> empty() {
        return new Page<>();
    }
}
