/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.mongo.dao.impl;

import com.ysscale.framework.model.page.Page;
import com.ysscale.framework.model.page.PageQuery;
import com.ysscale.mongo.dao.MongoBaseDao;
import com.ysscale.mongo.entity.MongoEntity;
import com.ysscale.mongo.utils.MongoPageable;
import com.ysscale.mongo.utils.PackageMongoPageInfo;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;

public abstract class MongoBaseDaoImpl<T extends MongoEntity>
implements MongoBaseDao<T> {
    @Autowired
    protected MongoTemplate mongoTemplate;
    protected Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public void saveOrUpdate(T t) {
        this.mongoTemplate.save(t);
    }

    @Override
    public List<T> findAll() {
        Query query = new Query();
        return this.mongoTemplate.find(query, this.clazz);
    }

    @Override
    public void saveOrUpdate(T t, String tableName) {
        this.mongoTemplate.save(t, tableName);
    }

    @Override
    public List<T> findAll(String tableName) {
        Query query = new Query();
        return this.mongoTemplate.find(query, this.clazz, tableName);
    }

    @Override
    public Page<T> pageForBeanList(Query query, int nowPage, int pageSize) {
        return this.pageForBeanList(query, nowPage, pageSize, null);
    }

    @Override
    public Page<T> pageForBeanList(Query query, int nowPage, int pageSize, String tableName) {
        Page page = new Page();
        long count = StringUtils.isEmpty((String)tableName) ? this.mongoTemplate.count(query, this.clazz) : this.mongoTemplate.count(query, this.clazz, tableName);
        page.setTotal((long)((int)count));
        PageRequest pageable = new PageRequest(nowPage - 1, pageSize);
        query.with((Pageable)pageable);
        List list = StringUtils.isEmpty((String)tableName) ? this.mongoTemplate.find(query, this.clazz) : this.mongoTemplate.find(query, this.clazz, tableName);
        page.setRows(list);
        page.setNowPage(nowPage);
        page.setPageSize(pageSize);
        long pageNumber = 0L;
        if (count > 0L) {
            pageNumber = count % (long)pageSize == 0L ? count / (long)pageSize : count / (long)pageSize + 1L;
        }
        page.setPageNumber((int)pageNumber);
        return page;
    }

    @Override
    public Page<T> pageForBeanPage(Query query, PageQuery pageQuery) {
        return this.pageForBeanPage(query, pageQuery, null);
    }

    @Override
    public Page<T> pageForBeanPage(Query query, PageQuery pageQuery, String tableName) {
        long count = StringUtils.isEmpty((String)tableName) ? this.mongoTemplate.count(query, this.clazz) : this.mongoTemplate.count(query, this.clazz, tableName);
        if (count == 0L) {
            return PackageMongoPageInfo.empty();
        }
        MongoPageable pageable = new MongoPageable(pageQuery, count);
        List list = new ArrayList();
        list = StringUtils.isBlank((String)tableName) ? this.mongoTemplate.find(query.with((Pageable)pageable), this.clazz) : this.mongoTemplate.find(query.with((Pageable)pageable), this.clazz, tableName);
        return PackageMongoPageInfo.packageInfo(list, pageable, count);
    }

    @Override
    public List<T> pageForBeanList(Query query, PageQuery pageQuery) {
        return this.pageForBeanList(query, pageQuery, null);
    }

    @Override
    public List<T> pageForBeanList(Query query, PageQuery pageQuery, String tableName) {
        MongoPageable pageable = new MongoPageable(pageQuery);
        List list = new ArrayList();
        list = StringUtils.isBlank((String)tableName) ? this.mongoTemplate.find(query.with((Pageable)pageable), this.clazz) : this.mongoTemplate.find(query.with((Pageable)pageable), this.clazz, tableName);
        return list;
    }

    @Override
    public void remove(T t) {
        this.mongoTemplate.remove(t);
    }

    @Override
    public void remove(T t, String tableName) {
        this.mongoTemplate.remove(t, tableName);
    }

    @Override
    public void dropTable() {
        this.mongoTemplate.dropCollection(this.clazz);
    }

    @Override
    public void dropTable(String tableName) {
        this.mongoTemplate.dropCollection(tableName);
    }
}

