/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.mongo.utils;

import com.ysscale.framework.model.page.PageQuery;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class MongoPageable
implements Serializable,
Pageable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPageable.class);
    private PageQuery pageQuery;
    private long count;

    public MongoPageable(PageQuery pageQuery) {
        this.pageQuery = pageQuery;
    }

    public MongoPageable(PageQuery pageQuery, long count) {
        this.pageQuery = pageQuery;
        this.count = count;
    }

    public int getPageNumber() {
        return (int)((this.count - 1L) / (long)this.pageQuery.getLimit() + 1L);
    }

    public int getPageSize() {
        return this.pageQuery.getLimit();
    }

    public long getOffset() {
        if (this.pageQuery.getPage() != 0) {
            return (this.pageQuery.getPage() - 1) * this.pageQuery.getLimit();
        }
        return this.pageQuery.getOffset();
    }

    public int getNowPage() {
        if (this.pageQuery.getPage() != 0) {
            return this.pageQuery.getPage();
        }
        if (this.pageQuery.getOffset() != 0) {
            return this.pageQuery.getOffset() / this.pageQuery.getLimit() + 1;
        }
        return 1;
    }

    public Sort getSort() {
        String[] orderParts;
        String orderStr = this.pageQuery.getOrder();
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (StringUtils.isNotBlank((CharSequence)orderStr) && (orderParts = orderStr.split(",")) != null && orderParts.length != 0) {
            for (String orderPart : orderParts) {
                String[] orderPar = orderPart.split(" ");
                if (orderPar != null && orderPar.length == 2) {
                    Sort.Order order = null;
                    if ("DESC".equalsIgnoreCase(orderPar[1])) {
                        order = new Sort.Order(Sort.Direction.DESC, orderPar[0]);
                    } else if ("ASC".equalsIgnoreCase(orderPar[1])) {
                        order = new Sort.Order(Sort.Direction.ASC, orderPar[0]);
                    } else {
                        LOGGER.error(orderPart + "\u6392\u5e8f\u683c\u5f0f\u9519\u8bef");
                        continue;
                    }
                    orders.add(order);
                    continue;
                }
                LOGGER.error(orderPart + "\u6392\u5e8f\u683c\u5f0f\u9519\u8bef");
            }
        }
        return new Sort(orders);
    }

    public Pageable next() {
        return null;
    }

    public Pageable previousOrFirst() {
        return null;
    }

    public Pageable first() {
        return null;
    }

    public boolean hasPrevious() {
        return false;
    }
}

