package com.ysscale.redis.service.impl;

import com.ysscale.framework.exception.BusinessException;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.interviewapi.client.InterviewMsgClient;
import com.ysscale.interviewapi.vo.MsgSendReq;
import com.ysscale.message.factory.IMsgService;
import com.ysscale.redis.content.ErrorCode;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @ClassName: AbstractMsgServiceImpl
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/2/19 21:28
 * @Version: V1.0.0
 */
@Service
public abstract class AbstractMsgServiceImpl implements IMsgService {

    protected static final String PREFIX = "MSG";

    @Autowired
    protected RedisTemplate<String, String> redisTemplate;

    @Autowired
    protected InterviewMsgClient interviewMsgClient;

    @Override
    public boolean checkCode(String account, String id, String code) throws CommonException {
        String key = String.format("%s_%s_%s", PREFIX, id, account);
        boolean res = checkCodeWithOutDel(account, id, code);
        if (res) {
            redisTemplate.delete(key);
        }
        return res;
    }

    @Override
    public boolean checkCodeWithOutDel(String account, String id, String code) throws CommonException {
        if (StringUtils.isBlank(code)) {
            throw new BusinessException(ErrorCode.STATUS_E_SEND_MESSAGE_CODE_EMPTY, "验证码为空");
        }

        ValueOperations<String, String> operations = redisTemplate.opsForValue();
        String key = String.format("%s_%s_%s", PREFIX, id, account);
        String resCode = operations.get(key);
        if (code.equalsIgnoreCase(resCode)) {
            return true;
        } else {
            throw new BusinessException("验证码错误");
        }
    }

    protected boolean sendInterview(Integer type, String account, String code) {
        List<String> params = new ArrayList<>();
        params.add(code);
        MsgSendReq msgSendReq = new MsgSendReq();
        msgSendReq.setAccount(account);
        msgSendReq.setType(type);
        msgSendReq.setParams(params);
        return send(msgSendReq);
    }

    protected boolean sendInterview(Integer type, String account, List<String> params) {
        MsgSendReq msgSendReq = new MsgSendReq();
        msgSendReq.setAccount(account);
        msgSendReq.setType(type);
        msgSendReq.setParams(params);
        return send(msgSendReq);
    }

    @Override
    public boolean sendMsg(Integer type, String account, String... params) throws CommonException {
        List<String> paramList = new ArrayList<>();
        paramList.addAll(Arrays.asList(params));
        return sendInterview(type, account, paramList);
    }

    public abstract boolean send(MsgSendReq msgSendReq);

    public abstract boolean saveRedis(String key, String code);
}
