package com.ysscale.redis.service.impl;

import com.ysscale.framework.content.YsscaleContents;
import com.ysscale.framework.core.utils.CodeUtils;
import com.ysscale.framework.core.utils.KidUtils;
import com.ysscale.framework.exception.BusinessException;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.framework.exception.SystemException;
import com.ysscale.interviewapi.vo.MsgSendReq;
import com.ysscale.message.config.PhoneConfig;
import com.ysscale.message.utils.SendMessage;
import com.ysscale.redis.content.ErrorCode;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @ClassName: PMsgServiceImpl
 * @Desprition: 短信验证
 * @Auth: lie_w
 * @Date: 2018/11/23 9:08
 * @Version: V1.0.0
 */
@Service(YsscaleContents.PHONE_SIGN)
public class PMsgServiceImpl extends AbstractMsgServiceImpl {

    @Autowired
    private PhoneConfig phoneConfig;

    @Override
    public String sendCode(Integer type, String mobile) throws CommonException {
        String id = KidUtils.generateShortUuid();
        sendCodeWithId(type, mobile, id);
        return id;
    }

    @Override
    public String sendCode(Integer type, String mobile, String... params) throws CommonException {
        String id = KidUtils.generateShortUuid();
        sendCodeWithId(type, mobile, id, params);
        return id;
    }

    @Override
    public boolean sendCodeWithId(Integer type, String mobile, String id) throws CommonException {

        if (StringUtils.isBlank(mobile)) {
            throw new BusinessException(ErrorCode.STATUS_E_NON_USER, "手机号不存在");
        }

        String key = String.format("%s_%s_%s", PREFIX, id, mobile);
        String code = CodeUtils.getCode6();

        boolean res = sendInterview(type, mobile, code);

        if (!res) {
            SendMessage.sendExpMsg("18082350542", "发送短信异常");
            throw new SystemException(ErrorCode.STATUS_E_SEND_MESSAGE_CODE, "发送验证码失败!");
        }
        return saveRedis(key, code);
    }

    @Override
    public boolean sendCodeWithId(Integer type, String mobile, String id, String... params) throws CommonException {
        if (StringUtils.isBlank(mobile)) {
            throw new BusinessException(ErrorCode.STATUS_E_NON_USER, "手机号不存在");
        }

        String key = String.format("%s_%s_%s", PREFIX, id, mobile);
        String code = CodeUtils.getCode6();

        List<String> paramList = new ArrayList<>();
        paramList.addAll(Arrays.asList(params));
        paramList.add(code);

        boolean res = sendInterview(type, mobile, paramList);

        if (!res) {
            SendMessage.sendExpMsg("18082350542", "发送短信异常");
            throw new SystemException(ErrorCode.STATUS_E_SEND_MESSAGE_CODE, "发送验证码失败!");
        }
        return saveRedis(key, code);
    }

    @Override
    public boolean send(MsgSendReq msgSendReq) {
        return interviewMsgClient.sendPMsg(msgSendReq);
    }

    @Override
    public boolean saveRedis(String key, String code) {
        ValueOperations<String, String> operations = redisTemplate.opsForValue();
        operations.set(key, code, phoneConfig.getSaveTime(), TimeUnit.MINUTES);
        return true;
    }
}
