/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.redis.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties
@ConfigurationProperties(prefix="spring.redis.sentinel")
public class RedisConfig {
    private static final Logger logger = LoggerFactory.getLogger(RedisConfig.class);
    @Value(value="${spring.redis.pool.max-active}")
    private long maxActive;
    @Value(value="${spring.redis.pool.max-wait}")
    private long maxWaitMillis;
    @Value(value="${spring.redis.pool.max-idle}")
    private int maxIdle;
    @Value(value="${spring.redis.pool.min-idle}")
    private int minIdle;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.commandTimeout}")
    private int commandTimeout;
    @Value(value="${spring.redis.max-redirects}")
    private int maxRedirects;
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.database}")
    private int database;
    private String master;
    private String nodes;

    @Bean
    public RedisClusterConfiguration getClusterConfiguration() {
        if (this.host.split(",").length > 1) {
            HashMap<String, Object> source = new HashMap<String, Object>();
            source.put("spring.redis.cluster.nodes", this.host);
            source.put("spring.redis.cluster.password", this.password);
            source.put("spring.redis.cluster.timeout", this.timeout);
            source.put("spring.redis.cluster.max-redirects", this.maxRedirects);
            return new RedisClusterConfiguration((PropertySource)new MapPropertySource("RedisClusterConfiguration", source));
        }
        return null;
    }

    @Bean
    public RedisSentinelConfiguration redisSentinelConfiguration() {
        if (StringUtils.isNotBlank((CharSequence)this.nodes)) {
            String[] hosts;
            RedisSentinelConfiguration configuration = new RedisSentinelConfiguration();
            for (String redisHost : hosts = this.nodes.split(",")) {
                String[] item = redisHost.split(":");
                configuration.addSentinel(new RedisNode(item[0], Integer.parseInt(item[1])));
            }
            configuration.setMaster(this.master);
            return configuration;
        }
        return null;
    }

    @Bean
    public JedisConnectionFactory jedisConnectionFactory() {
        if (StringUtils.isNotBlank((CharSequence)this.master)) {
            logger.info("redis \u54e8\u5175\u914d\u7f6e\u3002\u3002\u3002\u3002\u3002\u3002");
            JedisConnectionFactory jcf = new JedisConnectionFactory(this.redisSentinelConfiguration());
            String[] hostIp = this.host.split(":");
            jcf.setHostName(hostIp[0]);
            jcf.setPort(Integer.parseInt(hostIp[1]));
            jcf.setTimeout(this.timeout);
            jcf.setPassword(this.password);
            jcf.setDatabase(this.database);
            return jcf;
        }
        if (!this.host.contains(",")) {
            logger.info("redis \u5355\u70b9\u914d\u7f6e\u3002\u3002\u3002\u3002\u3002\u3002");
            JedisConnectionFactory jcf = new JedisConnectionFactory();
            String[] hostIp = this.host.split(":");
            jcf.setHostName(hostIp[0]);
            jcf.setPort(Integer.valueOf(hostIp[1]).intValue());
            jcf.setTimeout(this.timeout);
            jcf.setPassword(this.password);
            return jcf;
        }
        logger.info("redis \u96c6\u7fa4\u914d\u7f6e\u3002\u3002\u3002\u3002\u3002\u3002");
        JedisConnectionFactory jcf = new JedisConnectionFactory(this.getClusterConfiguration());
        return jcf;
    }

    @Bean
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    public long getMaxActive() {
        return this.maxActive;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getCommandTimeout() {
        return this.commandTimeout;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public int getDatabase() {
        return this.database;
    }

    public String getMaster() {
        return this.master;
    }

    public String getNodes() {
        return this.nodes;
    }

    public void setMaxActive(long maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public void setNodes(String nodes) {
        this.nodes = nodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisConfig)) {
            return false;
        }
        RedisConfig other = (RedisConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxActive() != other.getMaxActive()) {
            return false;
        }
        if (this.getMaxWaitMillis() != other.getMaxWaitMillis()) {
            return false;
        }
        if (this.getMaxIdle() != other.getMaxIdle()) {
            return false;
        }
        if (this.getMinIdle() != other.getMinIdle()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getCommandTimeout() != other.getCommandTimeout()) {
            return false;
        }
        if (this.getMaxRedirects() != other.getMaxRedirects()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.getDatabase() != other.getDatabase()) {
            return false;
        }
        String this$master = this.getMaster();
        String other$master = other.getMaster();
        if (this$master == null ? other$master != null : !this$master.equals(other$master)) {
            return false;
        }
        String this$nodes = this.getNodes();
        String other$nodes = other.getNodes();
        return !(this$nodes == null ? other$nodes != null : !this$nodes.equals(other$nodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxActive = this.getMaxActive();
        result = result * 59 + (int)($maxActive >>> 32 ^ $maxActive);
        long $maxWaitMillis = this.getMaxWaitMillis();
        result = result * 59 + (int)($maxWaitMillis >>> 32 ^ $maxWaitMillis);
        result = result * 59 + this.getMaxIdle();
        result = result * 59 + this.getMinIdle();
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getCommandTimeout();
        result = result * 59 + this.getMaxRedirects();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + this.getDatabase();
        String $master = this.getMaster();
        result = result * 59 + ($master == null ? 43 : $master.hashCode());
        String $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : $nodes.hashCode());
        return result;
    }

    public String toString() {
        return "RedisConfig(maxActive=" + this.getMaxActive() + ", maxWaitMillis=" + this.getMaxWaitMillis() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", timeout=" + this.getTimeout() + ", commandTimeout=" + this.getCommandTimeout() + ", maxRedirects=" + this.getMaxRedirects() + ", host=" + this.getHost() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", master=" + this.getMaster() + ", nodes=" + this.getNodes() + ")";
    }
}

