/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.redis.service.impl;

import com.ysscale.framework.exception.BusinessException;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.interviewapi.client.InterviewMsgClient;
import com.ysscale.interviewapi.vo.MsgSendReq;
import com.ysscale.message.factory.IMsgService;
import com.ysscale.redis.content.ErrorCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractMsgServiceImpl
implements IMsgService {
    protected static final String PREFIX = "MSG";
    @Autowired
    protected RedisTemplate<String, String> redisTemplate;
    @Autowired
    protected InterviewMsgClient interviewMsgClient;

    public boolean checkCode(String account, String id, String code) throws CommonException {
        String key = String.format("%s_%s_%s", PREFIX, id, account);
        boolean res = this.checkCodeWithOutDel(account, id, code);
        if (res) {
            this.redisTemplate.delete((Object)key);
        }
        return res;
    }

    public boolean checkCodeWithOutDel(String account, String id, String code) throws CommonException {
        if (StringUtils.isBlank((String)code)) {
            throw new BusinessException(ErrorCode.STATUS_E_SEND_MESSAGE_CODE_EMPTY.intValue(), new Object[]{"\u9a8c\u8bc1\u7801\u4e3a\u7a7a"});
        }
        ValueOperations operations = this.redisTemplate.opsForValue();
        String key = String.format("%s_%s_%s", PREFIX, id, account);
        String resCode = (String)operations.get((Object)key);
        if (code.equalsIgnoreCase(resCode)) {
            return true;
        }
        throw new BusinessException("\u9a8c\u8bc1\u7801\u9519\u8bef");
    }

    protected boolean sendInterview(Integer type, String account, String code) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(code);
        MsgSendReq msgSendReq = new MsgSendReq();
        msgSendReq.setAccount(account);
        msgSendReq.setType(type);
        msgSendReq.setParams(params);
        return this.send(msgSendReq);
    }

    protected boolean sendInterview(Integer type, String account, List<String> params) {
        MsgSendReq msgSendReq = new MsgSendReq();
        msgSendReq.setAccount(account);
        msgSendReq.setType(type);
        msgSendReq.setParams(params);
        return this.send(msgSendReq);
    }

    public boolean sendMsg(Integer type, String account, String ... params) throws CommonException {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.addAll(Arrays.asList(params));
        return this.sendInterview(type, account, paramList);
    }

    public abstract boolean send(MsgSendReq var1);

    public abstract boolean saveRedis(String var1, String var2);
}

