/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.redis.service.impl;

import com.ysscale.framework.core.utils.CodeUtils;
import com.ysscale.framework.core.utils.KidUtils;
import com.ysscale.framework.exception.BusinessException;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.framework.exception.SystemException;
import com.ysscale.interviewapi.vo.MsgSendReq;
import com.ysscale.message.config.EmailConfig;
import com.ysscale.message.utils.SendMessage;
import com.ysscale.redis.content.ErrorCode;
import com.ysscale.redis.service.impl.AbstractMsgServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

@Service(value="E")
public class EMsgServiceImpl
extends AbstractMsgServiceImpl {
    @Autowired
    private EmailConfig emailConfig;

    public String sendCode(Integer type, String email) throws CommonException {
        String id = KidUtils.generateShortUuid();
        this.sendCodeWithId(type, email, id);
        return id;
    }

    public String sendCode(Integer type, String email, String ... params) throws CommonException {
        String id = KidUtils.generateShortUuid();
        this.sendCodeWithId(type, email, id, params);
        return id;
    }

    public boolean sendCodeWithId(Integer type, String email, String id) throws CommonException {
        if (StringUtils.isBlank((String)email)) {
            throw new BusinessException(ErrorCode.STATUS_E_NON_USER.intValue(), new Object[]{"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String key = String.format("%s_%s_%s", "MSG", id, email);
        String code = CodeUtils.getCode6();
        boolean res = this.sendInterview(type, email, code);
        if (!res) {
            SendMessage.sendExpMsg((String)"18082350542", (String)"\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38");
            throw new SystemException(ErrorCode.STATUS_E_SEND_MESSAGE_CODE.intValue(), new Object[]{"\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25!"});
        }
        return this.saveRedis(key, code);
    }

    public boolean sendCodeWithId(Integer type, String email, String id, String ... params) throws CommonException {
        if (StringUtils.isBlank((String)email)) {
            throw new BusinessException(ErrorCode.STATUS_E_NON_USER.intValue(), new Object[]{"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String key = String.format("%s_%s_%s", "MSG", id, email);
        String code = CodeUtils.getCode6();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.addAll(Arrays.asList(params));
        paramList.add(code);
        boolean res = this.sendInterview(type, email, paramList);
        if (!res) {
            SendMessage.sendExpMsg((String)"18082350542", (String)"\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38");
            throw new SystemException(ErrorCode.STATUS_E_SEND_MESSAGE_CODE.intValue(), new Object[]{"\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25!"});
        }
        return this.saveRedis(key, code);
    }

    @Override
    public boolean send(MsgSendReq msgSendReq) {
        return this.interviewMsgClient.sendEMsg(msgSendReq);
    }

    @Override
    public boolean saveRedis(String key, String code) {
        ValueOperations operations = this.redisTemplate.opsForValue();
        operations.set((Object)key, (Object)code, (long)this.emailConfig.getSaveTime().intValue(), TimeUnit.MINUTES);
        return true;
    }
}

