/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.redis.service.impl;

import com.ysscale.redis.service.IRedisApplicationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisApplicationServiceImpl
implements IRedisApplicationService {
    @Autowired
    private RedisTemplate redisTemplate;
    private static final String SYMBOL_COLON = ":";

    @Override
    public void addKeyValue(String keyName, String key, Object value) {
        String saveKey = this.checkKey(keyName, key);
        this.redisTemplate.opsForValue().set((Object)saveKey, value);
    }

    @Override
    public void addKeyValue(String keyName, String key, Object value, long timeOut) {
        String saveKey = this.checkKey(keyName, key);
        this.redisTemplate.opsForValue().set((Object)saveKey, value, timeOut, TimeUnit.SECONDS);
    }

    @Override
    public void addKeyValue(String keyName, String key, Object value, long timeOut, TimeUnit timeUnit) {
        String saveKey = this.checkKey(keyName, key);
        this.redisTemplate.opsForValue().set((Object)saveKey, value, timeOut, timeUnit);
    }

    @Override
    public Object getKeyValue(String keyName, String key) {
        String getKey = this.checkKey(keyName, key);
        return this.redisTemplate.opsForValue().get((Object)getKey);
    }

    @Override
    public Object updateAndGetValue(String keyName, String key, Object newVal) {
        String updateKey = this.checkKey(keyName, key);
        return this.redisTemplate.opsForValue().getAndSet((Object)updateKey, newVal);
    }

    @Override
    public void removeKeyValue(String keyName, String key) {
        String removeKey = this.checkKey(keyName, key);
        this.redisTemplate.delete((Object)removeKey);
    }

    @Override
    public void removeKeyValue(String keyName, List<String> keys) {
        if (StringUtils.isBlank((CharSequence)keyName)) {
            this.redisTemplate.delete(keys);
        } else {
            ArrayList<String> deleteKeys = new ArrayList<String>();
            for (String key : keys) {
                String deleteKey = this.checkKey(keyName, key);
                deleteKeys.add(deleteKey);
            }
            this.redisTemplate.delete(deleteKeys);
        }
    }

    @Override
    public Long stringIncrement(String keyName, String key, long val) {
        String saveKey = this.checkKey(keyName, key);
        return this.redisTemplate.opsForValue().increment((Object)saveKey, val);
    }

    @Override
    public Double stringIncrement(String keyName, String key, double val) {
        String saveKey = this.checkKey(keyName, key);
        return this.redisTemplate.opsForValue().increment((Object)saveKey, val);
    }

    @Override
    public String addHashKey(String keyName, String key1, String key2, Object value) {
        String saveKey = this.checkKey(keyName, key1);
        this.redisTemplate.opsForHash().put((Object)saveKey, (Object)key2, value);
        return saveKey;
    }

    @Override
    public void addHashKey(String keyName, String key1, String key2, Object value, long timeOut) {
        String saveKey = this.addHashKey(keyName, key1, key2, value);
        this.redisTemplate.expire((Object)saveKey, timeOut, TimeUnit.SECONDS);
    }

    @Override
    public void addHashKey(String keyName, String key1, String key2, Object value, long timeOut, TimeUnit timeUnit) {
        String saveKey = this.addHashKey(keyName, key1, key2, value);
        this.redisTemplate.expire((Object)saveKey, timeOut, timeUnit);
    }

    @Override
    public String addHashKey(String keyName, String key1, Map value) {
        String saveKey = this.checkKey(keyName, key1);
        this.redisTemplate.opsForHash().putAll((Object)saveKey, value);
        return saveKey;
    }

    @Override
    public void addHashKey(String keyName, String key1, Map value, long timeOut) {
        String saveKey = this.addHashKey(keyName, key1, value);
        this.redisTemplate.expire((Object)saveKey, timeOut, TimeUnit.SECONDS);
    }

    @Override
    public void addHashKey(String keyName, String key1, Map value, long timeOut, TimeUnit timeUnit) {
        String saveKey = this.addHashKey(keyName, key1, value);
        this.redisTemplate.expire((Object)saveKey, timeOut, timeUnit);
    }

    @Override
    public boolean hasKey(String keyName, String key1, String key2) {
        String saveKey = this.checkKey(keyName, key1);
        return this.redisTemplate.opsForHash().hasKey((Object)saveKey, (Object)key2);
    }

    @Override
    public Long hashIncrement(String keyName, String key1, String key2, long val) {
        String saveKey = this.checkKey(keyName, key1);
        return this.redisTemplate.opsForHash().increment((Object)saveKey, (Object)key2, val);
    }

    @Override
    public Double hashIncrement(String keyName, String key1, String key2, double val) {
        String saveKey = this.checkKey(keyName, key1);
        return this.redisTemplate.opsForHash().increment((Object)saveKey, (Object)key2, val);
    }

    @Override
    public Object getHashVal(String keyName, String key1, String key2) {
        String saveKey = this.checkKey(keyName, key1);
        return this.redisTemplate.opsForHash().get((Object)saveKey, (Object)key2);
    }

    @Override
    public Map getHashValMap(String keyName, String key1) {
        String saveKey = this.checkKey(keyName, key1);
        return this.redisTemplate.opsForHash().entries((Object)saveKey);
    }

    @Override
    public List getHashValList(String keyName, String key1) {
        String saveKey = this.checkKey(keyName, key1);
        return this.redisTemplate.opsForHash().values((Object)saveKey);
    }

    @Override
    public void removeHashKeyValue(String keyName, String key1) {
        String saveKey = this.checkKey(keyName, key1);
        Map map = this.getHashValMap(keyName, key1);
        Set set = map.keySet();
        ArrayList list = new ArrayList();
        set.forEach(o -> list.add(o));
        this.redisTemplate.opsForHash().delete((Object)saveKey, list.toArray());
    }

    @Override
    public void removeHashKeyValue(String keyName, String key1, String key2) {
        String saveKey = this.checkKey(keyName, key1);
        this.redisTemplate.opsForHash().delete((Object)saveKey, new Object[]{key2});
    }

    @Override
    public void removeHashKeyValue(String keyName, String key1, List<String> key2s) {
        String saveKey = this.checkKey(keyName, key1);
        this.redisTemplate.opsForHash().delete((Object)saveKey, key2s.toArray());
    }

    @Override
    public void removeHashKeyValue(String keyName, List<String> key1s, String key2) {
        key1s.forEach(key1 -> this.redisTemplate.opsForHash().delete((Object)this.checkKey(keyName, (String)key1), new Object[]{key2}));
    }

    @Override
    public void removeHashKeyValue(String keyName, List<String> key1s, List<String> key2s) {
        key1s.forEach(key1 -> this.redisTemplate.opsForHash().delete((Object)this.checkKey(keyName, (String)key1), key2s.toArray()));
    }

    @Override
    public synchronized String addHashKeyKeyVal(String keyName, String key1, String key2, String key, Object value) {
        HashMap<String, Object> hashVal = (HashMap<String, Object>)this.getHashVal(keyName, key1, key2);
        if (hashVal == null) {
            hashVal = new HashMap<String, Object>();
        }
        hashVal.put(key, value);
        return this.addHashKey(keyName, key1, key2, hashVal);
    }

    @Override
    public void addHashKeyKeyVal(String keyName, String key1, String key2, String key, Object value, long timeOut) {
        String saveKey = this.addHashKeyKeyVal(keyName, key1, key2, key, value);
        this.redisTemplate.expire((Object)saveKey, timeOut, TimeUnit.SECONDS);
    }

    @Override
    public void addHashKeyKeyVal(String keyName, String key1, String key2, String key, Object value, long timeOut, TimeUnit timeUnit) {
        String saveKey = this.addHashKeyKeyVal(keyName, key1, key2, key, value);
        this.redisTemplate.expire((Object)saveKey, timeOut, timeUnit);
    }

    private String checkKey(String keyName, String key) {
        if (!StringUtils.isBlank((CharSequence)keyName)) {
            return keyName + SYMBOL_COLON + key;
        }
        return key;
    }
}

