package com.ysscale;

import com.ysscale.framework.utils.JSONUtils;
import com.ysscale.redis.service.RedisInivalidListener;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

/**
 * @ClassName: RedisConfiguration
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2018/11/26 12:22
 * @Version: V1.0.0
 */
@Slf4j
@ComponentScan
@Configuration
public class RedisConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public MessageListener messageListener() {
        return new MessageListener() {
            private Logger logger = LoggerFactory.getLogger(MessageListener.class);

            /**
             * Callback for processing received objects through Redis.
             *
             * @param message message must not be {@literal null}.
             * @param pattern pattern matching the channel (if specified) - can be {@literal null}.
             */
            @Override
            public void onMessage(Message message, byte[] pattern) {
                logger.info("onMessage >>" + message.toString());
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisInivalidListener redisInivalidListener() {
        return new RedisInivalidListener() {
            @Override
            public void onMessage(Message message, byte[] pattern, Object obj) {
                log.debug("Redis inivalid -> {}; Object -> {}", message.toString(), JSONUtils.objectToJson(obj));
            }
        };
    }
}
