package com.ysscale.redis.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @author lie_w
 * @title: SaveConfig
 * @projectName Rely-On-DB
 * @description: Redis保存内容
 * @date 2020/5/615:40
 */
@Data
@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "com.jhscale.redis.save")
public class SaveConfig {

    // 微信证书保存类型方式 true 时间保存 false 1年有效期保存
    private boolean wxCertSaveType = false;
}
