package com.ysscale.redis.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface IRedisApplicationService {
    /**
     * @description: Redis String类型操作
     **/
    void addKeyValue(String keyName, String key, Object value);

    void addKeyValue(String keyName, String key, Object value, long timeOut);

    void addKeyValue(String keyName, String key, Object value, long timeOut, TimeUnit timeUnit);

    Object getKeyValue(String keyName, String key);

    Object updateAndGetValue(String keyName, String key, Object newVal);

    void removeKeyValue(String keyName, String key);

    void removeKeyValue(String keyName, List<String> keys);

    Long stringIncrement(String keyName, String key, long val);

    Double stringIncrement(String keyName, String key, double val);

    /**
     * @description: 获取并替换
     **/
    Object getAndSet(String keyName, String key, Object val);

    /**
     * @description: Redis Hash类型操作
     **/
    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @param key2    VAL Key
     * @param value   VAL Val
     * @return
     */
    String addHashKey(String keyName, String key1, String key2, Object value);

    void addHashKey(String keyName, String key1, String key2, Object value, long timeOut);

    void addHashKey(String keyName, String key1, String key2, Object value, long timeOut, TimeUnit timeUnit);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @param value   HASH Val
     * @return
     */
    String addHashKey(String keyName, String key1, Map value);

    void addHashKey(String keyName, String key1, Map value, long timeOut);

    void addHashKey(String keyName, String key1, Map value, long timeOut, TimeUnit timeUnit);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @param key2    VAL Key
     * @description 判断KEY1下键KEY2是否存在
     */
    boolean hasKey(String keyName, String key1, String key2);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @param key2    VAL Key
     * @description ValValue + val 加
     */
    Long hashIncrement(String keyName, String key1, String key2, long val);

    Double hashIncrement(String keyName, String key1, String key2, double val);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @param key2    VAL Key
     * @description KEY1下 键KEY2 Val
     */
    Object getHashVal(String keyName, String key1, String key2);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @description KEY1下 所有键值对
     */
    Map getHashValMap(String keyName, String key1);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @description KEY1下 所有键值对的值
     */
    List getHashValList(String keyName, String key1);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @description 删除 KEY1下
     */
    void removeHashKeyValue(String keyName, String key1);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @param key2    删除 KEY1下键Key2
     */
    void removeHashKeyValue(String keyName, String key1, String key2);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @param key2s   删除 KEY1下键Key2s
     */
    void removeHashKeyValue(String keyName, String key1, List<String> key2s);

    /**
     * @param keyName 目录名称
     * @param key1s   HASH Key
     * @param key2    删除 所有KEY1下键Key2
     */
    void removeHashKeyValue(String keyName, List<String> key1s, String key2);

    /**
     * @param keyName 目录名称
     * @param key1s   HASH Key
     * @param key2s   删除 所有KEY1下键Key2s
     */
    void removeHashKeyValue(String keyName, List<String> key1s, List<String> key2s);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @param key2    Val Key
     * @param key     Data Key
     * @param value   DATA
     * @description: Redis Hash 添加对象MAP    使用前提，Redis Hash Val 是MAP
     */
    String addHashKeyKeyVal(String keyName, String key1, String key2, String key, Object value);

    void addHashKeyKeyVal(String keyName, String key1, String key2, String key, Object value, long timeOut);

    void addHashKeyKeyVal(String keyName, String key1, String key2, String key, Object value, long timeOut, TimeUnit timeUnit);

}
