package com.ysscale.redis.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author lie_w
 * @title: RedisHandleService
 * @projectName Rely-On-DB
 * @description: TODO
 * @date 2019/12/1214:04
 */
public interface RedisHandleService {

    String SYMBOL_COLON = ":";

    String HASH_INIVALID = "INIVALID_KEY";

    /**
     * @description: Redis String类型操作
     **/
    void addKeyValue(String keyName, String key, Object value);

    void addKeyValue(String keyName, String key, Object value, long timeOut);

    void addKeyValue(String keyName, String key, Object value, long timeOut, TimeUnit timeUnit);

    Object getKeyValue(String keyName, String key);

    List getKeyValues(String keyName, List<String> keys);

    Object getAndSet(String keyName, String key, Object value);

    void removeKeyValue(String keyName, String key);

    /**
     * @param keyName 目录名称
     * @param key1    HASH Key
     * @param key2    VAL Key
     * @param value   VAL Val
     * @description: Redis HASH类型操作
     */
    String addHashKey(String keyName, String key1, String key2, Object value);

    void addHashKey(String keyName, String key1, String key2, Object value, long timeOut);

    /**
     * @description: HASH保存 并且 没有监听逐条删除
     **/
    void addHashKeyWithoutDel(String keyName, String key1, String key2, Object value, long timeOut);

    void addHashKey(String keyName, String key1, String key2, Object value, long timeOut, TimeUnit timeUnit);

    /**
     * @description: HASH保存 并且 没有监听逐条删除
     **/
    void addHashKeyWithoutDel(String keyName, String key1, String key2, Object value, long timeOut, TimeUnit timeUnit);

    void addHashKey(String keyName, Map<String, Object> key1Data, String key2, long timeOut, TimeUnit timeUnit);

    void addHashKey(String keyName, String key1, Map<String, Object> key2Data, long timeOut, TimeUnit timeUnit);

    void removeHashKey(String keyName, String key1, String key2);

    Long removeHashKey(String keyName, String key1, String... key2s);

    Object getHashVal(String keyName, String key1, String key2);

    List getHashValList(String keyName, String key1);

    Map getHashValMap(String keyName, String key1);

    List getHashValList(String keyName, String key1, List<String> key2s);
}
