package com.ysscale.redis.service.impl;

import com.ysscale.framework.domain.WxAccessToken;
import com.ysscale.redis.service.RedisHandleService;
import com.ysscale.sevice.AccountCertUtilsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author lie_w
 * @title: AccountCertUtilsServiceImpl
 * @projectName Rely-On-DB
 * @description: TODO
 * @date 2020/4/711:17
 */
@Slf4j
@Service
public class AccountCertUtilsServiceImpl implements AccountCertUtilsService {

    @Autowired
    private RedisHandleService redisHandleService;

    /**
     * @param dirSign
     * @description: 获取公众号证书
     */
    @Override
    public WxAccessToken getAccesstoken(String... dirSign) {
        return (WxAccessToken) redisHandleService.getKeyValue(dirSign[0], dirSign[1]);
    }

    /**
     * @param accesstoken
     * @param dirSign
     * @description: 保存公众号证书
     */
    @Override
    public void saveAccesstoken(WxAccessToken accesstoken, String... dirSign) {
        if (Objects.isNull(accesstoken) || Objects.isNull(dirSign) || dirSign.length != 2) return;
        redisHandleService.addKeyValue(dirSign[0], dirSign[1], accesstoken, accesstoken.getExpires_in() - 10, TimeUnit.SECONDS);
    }

    /**
     * @param dirSign
     * @description: 移除公众号证书
     */
    @Override
    public void removeAccesstoken(String... dirSign) {
        redisHandleService.removeHashKey(dirSign[0], dirSign[1]);
    }
}
