package com.ysscale.redis.service.impl;

import com.ysscale.domain.CertInfo;
import com.ysscale.redis.config.SaveConfig;
import com.ysscale.redis.service.RedisHandleService;
import com.ysscale.sevice.PayCertUtilsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author lie_w
 * @title: CertUtilsServiceImpl
 * @projectName Rely-On-DB
 * @description: TODO
 * @date 2020/3/2217:28
 */
@Slf4j
@Service
public class PayCertUtilsServiceImpl implements PayCertUtilsService {

    @Autowired
    private RedisHandleService redisHandleService;

    @Autowired
    private SaveConfig saveConfig;

    /**
     * @param certInfo
     * @param dirSign
     * @description: 保存微信证书
     */
    @Override
    public boolean saveWxCertInfo(CertInfo certInfo, String... dirSign) {
        if (Objects.isNull(certInfo) || Objects.isNull(dirSign) || dirSign.length != 2) return false;
        if (saveConfig.isWxCertSaveType()) {
            int minutes = (int) ((certInfo.getExpireTime().getTime() - System.currentTimeMillis()) / 60000);
            redisHandleService.addKeyValue(dirSign[0], dirSign[1], certInfo, minutes, TimeUnit.MINUTES);
            return true;
        } else {
            redisHandleService.addKeyValue(dirSign[0], dirSign[1], certInfo, 365, TimeUnit.DAYS);
            return true;
        }
    }

    /**
     * @param dirSign
     * @description: 获取微信证书
     */
    @Override
    public CertInfo getWxCertInfo(String... dirSign) {
        if (Objects.isNull(dirSign) || dirSign.length != 2) return null;
        return (CertInfo) redisHandleService.getKeyValue(dirSign[0], dirSign[1]);
    }

    /**
     * @param dirSign
     * @description: 移除证书
     */
    @Override
    public void removeWxCertInfo(String... dirSign) {
        if (Objects.isNull(dirSign) || dirSign.length != 2) return;
        redisHandleService.removeHashKey(dirSign[0], dirSign[1]);
    }
}
