package com.ysscale.redis.service.impl;

import com.ysscale.redis.config.RedisConfig;
import com.ysscale.redis.service.RedisHandleService;
import com.ysscale.redis.service.RedisInivalidListener;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.stereotype.Service;

/**
 * @author lie_w
 * @title: RedisKeyInvalidListener
 * @projectName Rely-On-DB
 * @description: Redis Key失效监听
 * @date 2019/12/1214:08
 */
@Service
public class RedisKeyInvalidListener extends KeyExpirationEventMessageListener {

    @Autowired
    private RedisHandleService redisHandleService;

    @Autowired
    private RedisInivalidListener redisInivalidListener;

    @Autowired
    private RedisConfig redisConfig;

    /**
     * Creates new {@link RedisMessageListenerContainer} for {@code __keyevent@*__:expired} messages.
     *
     * @param listenerContainer must not be {@literal null}.
     */
    public RedisKeyInvalidListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    @Override
    public void onMessage(Message message, byte[] pattern) {
        if (!redisConfig.isListenInvalid()) return;
        String expiredKey = message.toString();
        Object obj = null;
        if (StringUtils.isNotBlank(expiredKey) && expiredKey.startsWith(RedisHandleService.HASH_INIVALID)) {
            String[] expiredKeyContents = expiredKey.split(RedisHandleService.SYMBOL_COLON);
            if (expiredKeyContents != null && expiredKeyContents.length > 0) {
                if (expiredKeyContents.length == 4) {
                    obj = redisHandleService.getHashVal(expiredKeyContents[1], expiredKeyContents[2], expiredKeyContents[3]);
                    redisHandleService.removeHashKey(expiredKeyContents[1], expiredKeyContents[2], expiredKeyContents[3]);
                }

                if (expiredKeyContents.length == 3) {
                    obj = redisHandleService.getHashVal("", expiredKeyContents[1], expiredKeyContents[2]);
                    redisHandleService.removeHashKey("", expiredKeyContents[1], expiredKeyContents[2]);
                }
            }
        }

        // todo 失效执行其他事件
        redisInivalidListener.onMessage(message, pattern, obj);
    }
}
