package com.ysscale.redis.service.impl;

import com.ysscale.redis.service.RedisLockService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

/**
 * @author lie_w
 * @title: RedisLockImpl
 * @projectName Rely-On-DB
 * @description: TODO
 * @date 2019/11/2716:44
 */
@Service
@Slf4j
public class RedisLockServiceImpl implements RedisLockService {

    @Autowired
    private RedisTemplate redisTemplate;

    private static final String DRIECTORY = "LOCK:";

    /**
     * 加锁
     *
     * @param key   键
     * @param value 当前时间 + 超时时间
     * @return 是否拿到锁
     */
    public boolean lock(String key, String value) {
        key = DRIECTORY + key;
        if (redisTemplate.opsForValue().setIfAbsent(key, value)) {
            return true;
        }
        String currentValue = (String) redisTemplate.opsForValue().get(key);
        //如果锁过期
        if (StringUtils.isNotBlank(currentValue)
                && Long.parseLong(currentValue) < System.currentTimeMillis()) {
            String oldValue = (String) redisTemplate.opsForValue().getAndSet(key, value);
            //是否已被别人抢占
            return StringUtils.isNotEmpty(oldValue) && oldValue.equals(currentValue);
        }
        return false;
    }

    /**
     * 解锁
     *
     * @param key   键
     * @param value 当前时间 + 超时时间
     */
    public void unlock(String key, String value) {
        key = DRIECTORY + key;
        String currentValue = (String) redisTemplate.opsForValue().get(key);
        if (StringUtils.isNotBlank(currentValue) && currentValue.equals(value)) {
            redisTemplate.opsForValue().getOperations().delete(key);
        }
    }
}
