package com.ysscale.redis.service.impl;

import com.ysscale.redis.service.IRedisApplicationService;
import com.ysscale.sevice.VerifyCodeSaveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

/**
 * @author lie_w
 * @title: VerifyCodeSaveServiceImpl
 * @projectName Rely-On-DB
 * @description: TODO
 * @date 2019/8/2919:53
 */
@Service
public class VerifyCodeSaveServiceImpl implements VerifyCodeSaveService {

    private static final String VERIFYCODE = "VERIFYCODE";

    @Autowired
    private IRedisApplicationService redisApplicationService;

    @Override
    public boolean saveCode(String key, String code, int saveTime) {
        redisApplicationService.addKeyValue(VERIFYCODE, key, code, saveTime, TimeUnit.MINUTES);
        return true;
    }

    @Override
    public String getCode(String key, boolean del) {
        Object value = redisApplicationService.getKeyValue(VERIFYCODE, key);
        if (del) redisApplicationService.removeKeyValue(VERIFYCODE, key);
        return (String) value;
    }

    @Override
    public boolean clear() {
        return true;
    }
}
