/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.socket.config;

import com.ysscale.socket.config.SocketPoolTaskExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class ExecutorConfig {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorConfig.class);
    @Value(value="${threadpool.core.size}")
    private int corePoolSize;
    @Value(value="${threadpool.max.size}")
    private int maxPoolSize;
    @Value(value="${threadpool.queueCapacity}")
    private int queueCapacity;
    @Value(value="${threadpool.keepalivesecconds}")
    private int keepAliveSeconds;

    @Bean(value={"vwebsocketDataTaskExecutor"})
    public Executor trandTaskExecutor() {
        logger.info("start web socket\u6570\u636e\u6d41\u4e0b\u53d1");
        SocketPoolTaskExecutor executor = new SocketPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize);
        executor.setMaxPoolSize(this.maxPoolSize);
        executor.setQueueCapacity(this.queueCapacity);
        executor.setKeepAliveSeconds(this.keepAliveSeconds);
        executor.setThreadNamePrefix("Socket\u53d1\u9001\u6570\u636e-");
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

