/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.socket.config;

import com.ysscale.socket.utils.SocketManager;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ysscale.websocket")
public class WebSocketConfig {
    private String nettyIp;
    private int nettyPort;
    private int maxConnection = 5000;
    private boolean hasCheckHeart = false;
    private int noReadHeartTime = 8;
    private int noWriteHeartTime = 5;
    private int socketKeySaveTime = 0;
    private String socketKey = "DEFAULT";

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
        SocketManager.getInstance().setMaxConnection(maxConnection);
    }

    public String getNettyIp() {
        return this.nettyIp;
    }

    public int getNettyPort() {
        return this.nettyPort;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public boolean isHasCheckHeart() {
        return this.hasCheckHeart;
    }

    public int getNoReadHeartTime() {
        return this.noReadHeartTime;
    }

    public int getNoWriteHeartTime() {
        return this.noWriteHeartTime;
    }

    public int getSocketKeySaveTime() {
        return this.socketKeySaveTime;
    }

    public String getSocketKey() {
        return this.socketKey;
    }

    public void setNettyIp(String nettyIp) {
        this.nettyIp = nettyIp;
    }

    public void setNettyPort(int nettyPort) {
        this.nettyPort = nettyPort;
    }

    public void setHasCheckHeart(boolean hasCheckHeart) {
        this.hasCheckHeart = hasCheckHeart;
    }

    public void setNoReadHeartTime(int noReadHeartTime) {
        this.noReadHeartTime = noReadHeartTime;
    }

    public void setNoWriteHeartTime(int noWriteHeartTime) {
        this.noWriteHeartTime = noWriteHeartTime;
    }

    public void setSocketKeySaveTime(int socketKeySaveTime) {
        this.socketKeySaveTime = socketKeySaveTime;
    }

    public void setSocketKey(String socketKey) {
        this.socketKey = socketKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketConfig)) {
            return false;
        }
        WebSocketConfig other = (WebSocketConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$nettyIp = this.getNettyIp();
        String other$nettyIp = other.getNettyIp();
        if (this$nettyIp == null ? other$nettyIp != null : !this$nettyIp.equals(other$nettyIp)) {
            return false;
        }
        if (this.getNettyPort() != other.getNettyPort()) {
            return false;
        }
        if (this.getMaxConnection() != other.getMaxConnection()) {
            return false;
        }
        if (this.isHasCheckHeart() != other.isHasCheckHeart()) {
            return false;
        }
        if (this.getNoReadHeartTime() != other.getNoReadHeartTime()) {
            return false;
        }
        if (this.getNoWriteHeartTime() != other.getNoWriteHeartTime()) {
            return false;
        }
        if (this.getSocketKeySaveTime() != other.getSocketKeySaveTime()) {
            return false;
        }
        String this$socketKey = this.getSocketKey();
        String other$socketKey = other.getSocketKey();
        return !(this$socketKey == null ? other$socketKey != null : !this$socketKey.equals(other$socketKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebSocketConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nettyIp = this.getNettyIp();
        result = result * 59 + ($nettyIp == null ? 43 : $nettyIp.hashCode());
        result = result * 59 + this.getNettyPort();
        result = result * 59 + this.getMaxConnection();
        result = result * 59 + (this.isHasCheckHeart() ? 79 : 97);
        result = result * 59 + this.getNoReadHeartTime();
        result = result * 59 + this.getNoWriteHeartTime();
        result = result * 59 + this.getSocketKeySaveTime();
        String $socketKey = this.getSocketKey();
        result = result * 59 + ($socketKey == null ? 43 : $socketKey.hashCode());
        return result;
    }

    public String toString() {
        return "WebSocketConfig(nettyIp=" + this.getNettyIp() + ", nettyPort=" + this.getNettyPort() + ", maxConnection=" + this.getMaxConnection() + ", hasCheckHeart=" + this.isHasCheckHeart() + ", noReadHeartTime=" + this.getNoReadHeartTime() + ", noWriteHeartTime=" + this.getNoWriteHeartTime() + ", socketKeySaveTime=" + this.getSocketKeySaveTime() + ", socketKey=" + this.getSocketKey() + ")";
    }

    public WebSocketConfig() {
    }

    public WebSocketConfig(String nettyIp, int nettyPort, int maxConnection, boolean hasCheckHeart, int noReadHeartTime, int noWriteHeartTime, int socketKeySaveTime, String socketKey) {
        this.nettyIp = nettyIp;
        this.nettyPort = nettyPort;
        this.maxConnection = maxConnection;
        this.hasCheckHeart = hasCheckHeart;
        this.noReadHeartTime = noReadHeartTime;
        this.noWriteHeartTime = noWriteHeartTime;
        this.socketKeySaveTime = socketKeySaveTime;
        this.socketKey = socketKey;
    }
}

