/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.socket.controller;

import com.ysscale.socket.service.SocketService;
import com.ysscale.socket.vo.ServerWebSocket;
import com.ysscale.socket.vo.WebSocketNotice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/webSocket"})
public class SocketController {
    @Autowired
    private SocketService socketService;

    @RequestMapping(value={"/notice"}, method={RequestMethod.POST})
    public boolean notice(@RequestBody WebSocketNotice notice) {
        if (this.socketService.check(notice.getKey())) {
            this.socketService.notice(notice);
            return true;
        }
        return false;
    }

    @GetMapping(value={"/check"})
    public boolean check(@RequestParam(value="key") String key) {
        return this.socketService.check(key);
    }

    @RequestMapping(value={"/getWebServer"}, method={RequestMethod.GET})
    public ServerWebSocket getWebServer() {
        return this.socketService.getWebServer();
    }
}

