/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.socket.service.impl;

import com.ysscale.socket.config.WebSocketConfig;
import com.ysscale.socket.service.InitService;
import com.ysscale.socket.websocket.WebSocketServerChannelInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitServiceImpl
implements InitService {
    @Autowired
    private WebSocketServerChannelInitializer webSocketServerChannelInitializer;
    @Autowired
    private WebSocketConfig webSocketConfig;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ServerBootstrap b;
    private Logger logger = LoggerFactory.getLogger(InitServiceImpl.class);

    @Override
    public void start() {
        if (this.bossGroup == null) {
            this.bossGroup = new NioEventLoopGroup();
        }
        if (this.workerGroup == null) {
            this.workerGroup = new NioEventLoopGroup();
        }
        if (this.b == null) {
            this.b = new ServerBootstrap();
        }
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.TCP_NODELAY, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(592048)).childHandler((ChannelHandler)this.webSocketServerChannelInitializer);
        try {
            this.b.bind(this.webSocketConfig.getNettyPort());
            this.logger.info("socket: {} starting....", (Object)this.webSocketConfig.getNettyPort());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.bossGroup = null;
        }
        this.b = null;
        this.logger.info("socket closing....");
    }
}

