/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.socket.service.impl;

import com.ysscale.framework.utils.JSONUtils;
import com.ysscale.redis.service.IRedisApplicationService;
import com.ysscale.socket.config.WebSocketConfig;
import com.ysscale.socket.service.SocketService;
import com.ysscale.socket.utils.SocketManager;
import com.ysscale.socket.utils.SocketUtils;
import com.ysscale.socket.vo.ServerWebSocket;
import com.ysscale.socket.vo.WebSocketNotice;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SocketServiceImpl
implements SocketService {
    @Autowired
    private IRedisApplicationService redisApplicationService;
    @Autowired
    private Registration registration;
    @Autowired
    private WebSocketConfig webSocketConfig;
    private String ipPort = null;
    private String ipPortKey = null;
    private String webSocketKey = null;

    @Override
    public String getIpPortKey() {
        if (this.ipPort == null) {
            this.ipPort = this.webSocketConfig.getSocketKey() + "-IPPORT";
        }
        return this.ipPortKey;
    }

    @Override
    public String getWebSocketKey() {
        if (this.webSocketKey == null) {
            this.webSocketKey = this.webSocketConfig.getSocketKey() + "-WEBSOCKET";
        }
        return this.webSocketKey;
    }

    private String getIpPort() {
        if (this.ipPort == null) {
            String ipAddress = this.registration.getHost();
            int port = this.registration.getPort();
            this.ipPort = String.format("%s:%d", ipAddress, port);
        }
        return this.ipPort;
    }

    @Override
    @Async(value="vwebsocketDataTaskExecutor")
    public void notice(WebSocketNotice notice) {
        String keyValue = (String)this.redisApplicationService.getKeyValue(this.getIpPortKey(), notice.getKey());
        if (StringUtils.isNotBlank((CharSequence)keyValue)) {
            String[] ipports = keyValue.split("#");
            SocketUtils.sendMsg(ipports[1], JSONUtils.objectToJson((Object)notice.getMsg()));
        }
    }

    @Override
    public boolean noticeWithCheck(WebSocketNotice notice) {
        if (this.check(notice.getKey())) {
            this.notice(notice);
            return true;
        }
        return false;
    }

    @Override
    public void create(String uniqueKey) {
        String modelName = this.getModelName();
        String key = modelName + "#" + uniqueKey;
        if (this.webSocketConfig.getSocketKeySaveTime() == 0) {
            this.redisApplicationService.addKeyValue(this.getWebSocketKey(), key, (Object)"");
        } else {
            this.redisApplicationService.addKeyValue(this.getWebSocketKey(), key, (Object)"", (long)this.webSocketConfig.getSocketKeySaveTime(), TimeUnit.HOURS);
        }
    }

    @Override
    public void remove(String uniqueKey) {
        String wb_key = this.getModelName() + "#" + uniqueKey;
        String ip_key = (String)this.redisApplicationService.getKeyValue(this.getWebSocketKey(), wb_key);
        if (StringUtils.isNotBlank((CharSequence)ip_key)) {
            this.redisApplicationService.removeKeyValue(this.getIpPortKey(), ip_key);
        }
        this.redisApplicationService.removeKeyValue(this.getWebSocketKey(), wb_key);
    }

    @Override
    public void putKey(String uniqueKey, String key) {
        String wb_key = this.getModelName() + "#" + uniqueKey;
        if (this.webSocketConfig.getSocketKeySaveTime() == 0) {
            this.redisApplicationService.addKeyValue(this.getWebSocketKey(), wb_key, (Object)key);
            this.redisApplicationService.addKeyValue(this.getIpPortKey(), key, (Object)wb_key);
        } else {
            this.redisApplicationService.addKeyValue(this.getWebSocketKey(), wb_key, (Object)key, (long)this.webSocketConfig.getSocketKeySaveTime(), TimeUnit.HOURS);
            this.redisApplicationService.addKeyValue(this.getIpPortKey(), key, (Object)wb_key, (long)this.webSocketConfig.getSocketKeySaveTime(), TimeUnit.HOURS);
        }
    }

    @Override
    public String getModelName() {
        return this.getIpPort();
    }

    @Override
    public boolean check(String key) {
        Object keyValue = this.redisApplicationService.getKeyValue(this.getIpPortKey(), key);
        return Objects.nonNull(keyValue);
    }

    @Override
    public ServerWebSocket getWebServer() {
        ServerWebSocket serverWebSocket = new ServerWebSocket();
        serverWebSocket.setIp(this.webSocketConfig.getNettyIp());
        serverWebSocket.setPort(this.webSocketConfig.getNettyPort());
        serverWebSocket.setMaxCount(this.webSocketConfig.getMaxConnection());
        serverWebSocket.setNowCount(SocketManager.getInstance().getNowConnection());
        return serverWebSocket;
    }
}

