/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.socket.utils;

import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SocketManager {
    private int maxConnection;
    private int nowConnection;
    private volatile boolean allowConnection = true;
    private Map<String, Channel> clients = new ConcurrentHashMap<String, Channel>();

    private SocketManager() {
    }

    public static SocketManager getInstance() {
        return SingletonHandler.singleton;
    }

    public void addClient(Channel client) {
        String modelName = client.remoteAddress().toString();
        this.clients.put(modelName, client);
        this.nowConnection = this.clients.size();
        this.allowConnection = this.nowConnection <= this.maxConnection;
    }

    public void removeClient(Channel client) {
        String modelName = client.remoteAddress().toString();
        this.clients.remove(modelName);
        this.nowConnection = this.clients.size();
        this.allowConnection = this.nowConnection <= this.maxConnection;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public int getNowConnection() {
        return this.nowConnection;
    }

    public boolean isAllowConnection() {
        return this.allowConnection;
    }

    public Channel getChannelByUniqueKey(String uniqueKey) {
        return this.clients.get(uniqueKey);
    }

    private static class SingletonHandler {
        private static SocketManager singleton = new SocketManager();

        private SingletonHandler() {
        }
    }
}

