/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.socket.websocket;

import com.ysscale.socket.config.WebSocketConfig;
import com.ysscale.socket.service.SocketService;
import com.ysscale.socket.utils.SocketManager;
import com.ysscale.socket.websocket.WebSocketHandlerEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class WebSocketHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHandler.class);
    private WebSocketServerHandshaker handshaker;
    @Autowired
    private WebSocketHandlerEvent webSocketHandlerEvent;
    @Autowired
    private SocketService socketService;
    @Autowired
    private WebSocketConfig webSocketConfig;

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            logger.info("handleHttpRequest.");
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        }
        if (msg instanceof WebSocketFrame) {
            logger.info("WebSocketFrame.");
            this.handlerWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        logger.info("on connection->{}", (Object)ctx);
        if (SocketManager.getInstance().isAllowConnection()) {
            SocketManager.getInstance().addClient(ctx.channel());
            this.webSocketHandlerEvent.onConnectionEvent(ctx);
            this.socketService.create(ctx.channel().remoteAddress().toString());
        } else {
            logger.error("not allow connection - > " + ctx + ",nowConnectionSize->" + SocketManager.getInstance().getNowConnection() + ",maxConnectionSize->" + SocketManager.getInstance().getMaxConnection());
            ctx.close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        logger.info("disconnection - > " + ctx);
        this.socketService.remove(ctx.channel().remoteAddress().toString());
        this.webSocketHandlerEvent.onDisConnectionEvent(ctx);
        SocketManager.getInstance().removeClient(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass()) && this.webSocketConfig.isHasCheckHeart()) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.READER_IDLE) {
                logger.debug("noReaderEvent.");
                this.webSocketHandlerEvent.noReaderEvent(ctx);
            } else if (event.state() == IdleState.WRITER_IDLE) {
                logger.debug("noWriterEvent.");
                this.webSocketHandlerEvent.noWriterEvent(ctx);
            } else if (event.state() == IdleState.ALL_IDLE) {
                // empty if block
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel incoming = ctx.channel();
        logger.error("Client:" + incoming.remoteAddress() + "\u5f02\u5e38");
        cause.printStackTrace();
        ctx.close();
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws UnsupportedEncodingException {
        if (!req.getDecoderResult().isSuccess() || !"websocket".equals(req.headers().get("Upgrade"))) {
            this.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory("ws:/" + ctx.channel() + "/websocket", null, false);
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), req);
        }
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, DefaultFullHttpResponse res) {
        if (res.getStatus().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void handlerWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            throw new Exception("\u4ec5\u652f\u6301\u6587\u672c\u683c\u5f0f");
        }
        TextWebSocketFrame msg = (TextWebSocketFrame)frame;
        this.webSocketHandlerEvent.readTextWebSocketFrameEvent(ctx, msg);
    }
}

