/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.socket.websocket;

import com.ysscale.socket.config.WebSocketConfig;
import com.ysscale.socket.websocket.WebSocketHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebSocketServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    @Autowired
    private WebSocketHandler webSocketHandler;
    @Autowired
    private WebSocketConfig webSocketConfig;

    protected void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast("http-codec", (ChannelHandler)new HttpServerCodec());
        ch.pipeline().addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
        ch.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
        ch.pipeline().addLast("heart-time", (ChannelHandler)new IdleStateHandler((long)this.webSocketConfig.getNoReadHeartTime(), (long)this.webSocketConfig.getNoWriteHeartTime(), (long)this.webSocketConfig.getNoWriteHeartTime(), TimeUnit.SECONDS));
        ch.pipeline().addLast("handler", (ChannelHandler)this.webSocketHandler);
    }
}

