package com.ysscale.socket.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * @ClassName: ExecutorConfig
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/2/19 10:58
 * @Version: V1.0.0
 */
@Configuration
@EnableAsync
@SuppressWarnings("all")
public class ExecutorConfig {

    private static final Logger logger = LoggerFactory.getLogger(ExecutorConfig.class);


    @Value("${threadpool.core.size}")
    private int corePoolSize;

    @Value("${threadpool.max.size}")
    private int maxPoolSize;

    @Value("${threadpool.queueCapacity}")
    private int queueCapacity;

    @Value("${threadpool.keepalivesecconds}")
    private int keepAliveSeconds;

    @Bean("vwebsocketDataTaskExecutor")
    public Executor trandTaskExecutor() {
        logger.info("start web socket数据流下发");
        ThreadPoolTaskExecutor executor = new SocketPoolTaskExecutor();
        //配置核心线程数
        executor.setCorePoolSize(corePoolSize);
        //配置最大线程数
        executor.setMaxPoolSize(maxPoolSize);
        //配置队列大小
        executor.setQueueCapacity(queueCapacity);
        // 设置线程活跃时间（秒）
        executor.setKeepAliveSeconds(keepAliveSeconds);
//        // 表明等待所有线程执行完
//        executor.setWaitForTasksToCompleteOnShutdown(waitForTasksToCompleteOnShutdown);
//        // （默认为0，此时立即停止），并没等待xx秒后强制停止
//        executor.setAwaitTerminationSeconds(awaitTerminationSeconds);
        //配置线程池中的线程的名称前缀
        executor.setThreadNamePrefix("Socket发送数据-");
        // rejection-policy：当pool已经达到max size的时候，如何处理新任务
        // CALLER_RUNS：不在新线程中执行任务，而是有调用者所在的线程来执行
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        //执行初始化
        executor.initialize();
        return executor;
    }
}
