package com.ysscale.socket.config;

import com.ysscale.socket.utils.SocketManager;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @ClassName: WebSocketConfig
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/20 21:02
 * @Version: V1.0.0
 */
@Component
@ConfigurationProperties(prefix = "ysscale.websocket")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class WebSocketConfig {

    /**
     * netty-ip
     */
    private String nettyIp;

    /**
     * netty-port
     */
    private int nettyPort;

    /**
     * 最大承载连接数
     */
    private int maxConnection = 5000;

    /**
     * 心跳检测-开启状态
     */
    private boolean hasCheckHeart = false;

    /**
     * 心跳检测-多久未读取数据
     */
    private int noReadHeartTime = 8;

    /**
     * 心跳检测-多久未写数据
     */
    private int noWriteHeartTime = 5;

    /**
     * socket key 保存时间
     */
    private int socketKeySaveTime = 0;

    /**
     * socket key 标识
     */
    private String socketKey = "DEFAULT";

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
        SocketManager.getInstance().setMaxConnection(maxConnection);
    }
}
