package com.ysscale.socket.controller;

import com.ysscale.socket.service.SocketService;
import com.ysscale.socket.vo.ServerWebSocket;
import com.ysscale.socket.vo.WebSocketNotice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName: SocketController
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/20 21:12
 * @Version: V1.0.0
 */
@RestController
@RequestMapping("/webSocket")
public class SocketController {

    @Autowired
    private SocketService socketService;

    @RequestMapping(value = "/notice", method = RequestMethod.POST)
    public boolean notice(@RequestBody WebSocketNotice notice) {
        if (socketService.check(notice.getKey())) {
            socketService.notice(notice);
            return true;
        } else {
            return false;
        }
    }

    @GetMapping("/check")
    public boolean check(@RequestParam("key") String key) {
        return socketService.check(key);
    }

    @RequestMapping(value = "/getWebServer", method = RequestMethod.GET)
    public ServerWebSocket getWebServer() {
        return socketService.getWebServer();
    }
}
