package com.ysscale.socket.service;

import com.ysscale.socket.vo.ServerWebSocket;
import com.ysscale.socket.vo.WebSocketNotice;
import io.netty.channel.ChannelHandlerContext;

import java.util.Objects;

public interface SocketService {
    /**
     * @Description 通知设备
     **/
    void notice(WebSocketNotice notice);

    /**
     * @Description 通知设备
     **/
    boolean noticeWithCheck(WebSocketNotice notice);

    /**
     * @description: 通知设备
     **/
    boolean noticeWithCheck(String key, String msg);

    /**
     * 创建管道数据
     *
     * @param uniqueKey 唯一标示
     */
    void create(String uniqueKey);

    /**
     * 删除管道数据
     *
     * @param uniqueKey 唯一标示
     */
    void remove(String uniqueKey);

    /**
     * @Description 添加Key
     **/
    void putKey(String uniqueKey, String key);

    /**
     * @Description 添加Key + 时效
     **/
    void putKey(String uniqueKey, String key, int num);

    /**
     * 获取模块名称，也可以直接调用getIpPort()
     *
     * @return 模块名称
     */
    String getModelName();

    /**
     * @Description 检查设备在线状态
     **/
    boolean check(String key);

    /**
     * @Description 获取websocket客户端
     * @Author wanglie
     * @Date 21:47 2019/3/30
     **/
    ServerWebSocket getWebServer();

    /**
     * @description: 获取redis ipport key
     **/
    String getIpPortKey();

    /**
     * @description: 获取webSocket key
     **/
    String getWebSocketKey();

    /**
     * @description: 获取终端IP
     **/
    String getTerminalIp(ChannelHandlerContext ctx);
}
