package com.ysscale.socket.service.impl;

import com.ysscale.framework.utils.JSONUtils;
import com.ysscale.redis.service.IRedisApplicationService;
import com.ysscale.socket.service.AsyncService;
import com.ysscale.socket.utils.SocketUtils;
import com.ysscale.socket.vo.WebSocketNotice;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @author lie_w
 * @title: AsyncServiceImpl
 * @projectName socket
 * @description: TODO
 * @date 2019/6/2417:15
 */
@Service
public class AsyncServiceImpl implements AsyncService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncServiceImpl.class);

    @Autowired
    private IRedisApplicationService redisApplicationService;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    @Async("vwebsocketDataTaskExecutor")
    public void notice(WebSocketNotice notice, String ipPortKey, String ipPort) {
        String keyValue = (String) redisApplicationService.getKeyValue(ipPortKey, notice.getKey());
        if (StringUtils.isNotBlank(keyValue)) {
            String[] ipports = keyValue.split("#");
            if (ipPort.equals(ipports[0])) {
                LOGGER.info("本服务发送 val：" + keyValue);
                SocketUtils.sendMsg(ipports[1].replace("-", ":"), JSONUtils.objectToJson(notice.getMsg()));
            } else {
                Boolean res = restTemplate.postForObject(ipports[0].replace("-", ":") + "/webSocket/notice", notice, Boolean.class);
                LOGGER.info("非本Socket 转发至 " + ipports[0] + (res ? " SUCCESS" : " FAIL"));
            }
        }
    }
}
