package com.ysscale.socket.service.impl;

import com.ysscale.socket.config.WebSocketConfig;
import com.ysscale.socket.service.InitService;
import com.ysscale.socket.websocket.WebSocketServerChannelInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @ClassName: InitServiceImpl
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/20 22:54
 * @Version: V1.0.0
 */
@Service
@SuppressWarnings("all")
public class InitServiceImpl implements InitService {

    @Autowired
    private WebSocketServerChannelInitializer webSocketServerChannelInitializer;

    @Autowired
    private WebSocketConfig webSocketConfig;

    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    private ServerBootstrap b;

    private Logger logger = LoggerFactory.getLogger(InitServiceImpl.class);

    @Override
    public void start() {
        if (bossGroup == null) {
            bossGroup = new NioEventLoopGroup();
        }
        if (workerGroup == null) {
            workerGroup = new NioEventLoopGroup();
        }

        if (b == null) {
            b = new ServerBootstrap();
        }

        b.group(bossGroup, workerGroup)
                .channel(NioServerSocketChannel.class)
                .option(ChannelOption.SO_BACKLOG, 1024)
                .option(ChannelOption.TCP_NODELAY, true)
                .childOption(ChannelOption.SO_KEEPALIVE, true)
                .childOption(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(592048))
                .childHandler(webSocketServerChannelInitializer);

        try {
            b.bind(webSocketConfig.getNettyPort());

            logger.info("socket: {} starting....", webSocketConfig.getNettyPort());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (workerGroup != null) {
            workerGroup.shutdownGracefully();
            workerGroup = null;
        }
        if (bossGroup != null) {
            bossGroup.shutdownGracefully();
            bossGroup = null;
        }
        b = null;

        logger.info("socket closing....");
    }
}
