package com.ysscale.socket.utils;

import io.netty.channel.Channel;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @ClassName: SocketManager
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/20 22:45
 * @Version: V1.0.0
 */
public class SocketManager {

    /**
     * 最大连接数
     */
    private int maxConnection;

    /**
     * 当前连接数
     */
    private int nowConnection;

    /**
     * 允许连接请求 true允许 false拒绝
     */
    private volatile boolean allowConnection = true;

    private Map<String, Channel> clients = null;

    private SocketManager() {
        clients = new ConcurrentHashMap<>();
    }

    private static class SingletonHandler {
        private static SocketManager singleton = new SocketManager();
    }

    public static SocketManager getInstance(){
        return SingletonHandler.singleton;
    }

    public void addClient(Channel client) {
        String modelName = client.remoteAddress().toString();
        clients.put(modelName, client);
        nowConnection = clients.size();
        allowConnection = (nowConnection <= maxConnection);
    }

    public void removeClient(Channel client) {
        String modelName = client.remoteAddress().toString();
        clients.remove(modelName);
        nowConnection = clients.size();
        allowConnection = (nowConnection <= maxConnection);
    }

    public int getMaxConnection() {
        return maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public int getNowConnection() {
        return nowConnection;
    }

    public boolean isAllowConnection() {
        return allowConnection;
    }

    public Channel getChannelByUniqueKey(String uniqueKey) {
        return clients.get(uniqueKey);
    }
}
