package com.ysscale.socket.utils;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

/**
 * @ClassName: SocketUtils
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/20 22:30
 * @Version: V1.0.0
 */
public class SocketUtils {

    public static void sendMsg(Channel channel, String msg){
        TextWebSocketFrame tws = new TextWebSocketFrame(msg);
        channel.writeAndFlush(tws);
    }

    public static void sendMsg(ChannelHandlerContext ctx, String msg){
        sendMsg(ctx.channel(),msg);
    }

    public static void sendMsg(String uniqueKey, String msg){
        sendMsg(SocketManager.getInstance().getChannelByUniqueKey(uniqueKey),msg);
    }
}
