package com.ysscale.socket.websocket;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

public interface WebSocketHandlerEvent {

    /**
     * 处理发送的数据
     *
     * @param ctx
     * @param msg
     */
    void readTextWebSocketFrameEvent(ChannelHandlerContext ctx, TextWebSocketFrame msg);

    /**
     * 心跳间隔时间没有读到数据事件
     *
     * @param ctx
     */
    void noReaderEvent(ChannelHandlerContext ctx);

    /**
     * 心跳间隔时间没有写数据事件
     *
     * @param ctx
     */
    void noWriterEvent(ChannelHandlerContext ctx);

    /**
     * 成功建立连接事件
     *
     * @param ctx
     */
    void onConnectionEvent(ChannelHandlerContext ctx);

    /**
     * 关闭连接事件
     *
     * @param ctx
     */
    void onDisConnectionEvent(ChannelHandlerContext ctx);
}
