package com.ysscale.socket.websocket;

import com.ysscale.socket.config.WebSocketConfig;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * @ClassName: WebSocketServerChannelInitializer
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/20 22:57
 * @Version: V1.0.0
 */
@Component
public class WebSocketServerChannelInitializer extends ChannelInitializer<SocketChannel> {

    @Autowired
    private WebSocketHandler webSocketHandler;

    @Autowired
    private WebSocketConfig webSocketConfig;

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast("http-codec", new HttpServerCodec());
        ch.pipeline().addLast("aggregator", new HttpObjectAggregator(65536));
        ch.pipeline().addLast("http-chunked", new ChunkedWriteHandler());
        ch.pipeline().addLast("heart-time",new IdleStateHandler(webSocketConfig.getNoReadHeartTime(),
                webSocketConfig.getNoWriteHeartTime(), webSocketConfig.getNoWriteHeartTime(), TimeUnit.SECONDS));
        ch.pipeline().addLast("handler",webSocketHandler);
    }
}
