package com.jhscale.network;

import com.jhscale.network.client.UploadFoodPriceClient;
import com.jhscale.network.client.impl.TelecomServerClient;
import com.jhscale.network.config.NetWorkConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * @author lie_w
 * @title: NetWorkConfiguration
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2022/10/1215:53
 */
@Slf4j
@ComponentScan
@Configuration
public class NetWorkConfiguration {

    /**
     * @description: 菜价上报客户端
     **/
    @ConditionalOnMissingBean
    @Bean
    public UploadFoodPriceClient uploadFoodPriceClient(@Autowired NetWorkConfig workConfig) {
        return new UploadFoodPriceClient(workConfig);
    }

    /**
     * @description: 电信服务接口客户端
     **/
    @ConditionalOnMissingBean
    @Bean
    public TelecomServerClient telecomServerClient() {
        return new TelecomServerClient();
    }
}
