package com.jhscale.network.entity.food;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description:
 * @date 2023/7/19 9:08
 */
@ApiModel
@Data
public abstract class AbstractMarketRequest<T extends BaseMarketResponse> implements BaseMarketRequest<T> {
    @JsonIgnore
    @ApiModelProperty(notes = "市场方id, 用于寻找对应token", required = true)
    protected String marketId;

    @JsonIgnore
    @ApiModelProperty(notes = "url前缀")
    protected String urlPrefix = "";

    /**
     * @description: 市场方id
     **/
    @Override
    public String marketId() {
        return marketId;
    }

    /**
     * @description: 请求方法
     **/
    @Override
    public RequestMethod method() {
        return RequestMethod.POST;
    }

    /**
     * @description: 是否formData提交
     **/
    @Override
    public boolean formDataPost() {
        return false;
    }

    /**
     * @description: 转换实际请求对象
     **/
    @Override
    public Object parseRequest() {
        return null;
    }
}
