package com.jhscale.network.entity.food;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.jhscale.network.client.UploadFoodPriceClient.SUCCESS_CODE;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description:
 * @date 2023/7/28 20:14
 */
@Data
public class BaseMarketParentResponse<T> implements BaseMarketResponse {
    @ApiModelProperty(notes = "响应码 200：处理成功")
    private String msg;
    @ApiModelProperty(notes = "返回结果信息")
    private Integer code;
    @ApiModelProperty(notes = "返回的数据")
    private T data;

    public boolean result() {
        return Integer.valueOf(SUCCESS_CODE).equals(this.code);
    }

}
