package com.jhscale.network.entity.food;

import org.springframework.web.bind.annotation.RequestMethod;

import java.io.Serializable;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description:
 * @date 2023/7/19 9:14
 */
public interface BaseMarketRequest<T extends BaseMarketResponse> extends Serializable {

    /**
     * @description: url前缀
     **/
    String getUrlPrefix();

    /**
     * @description: URL 地址
     **/
    String url();

    /**
     * @description: 市场方id
     **/
    String marketId();

    /**
     * @description: 请求方法
     **/
    RequestMethod method();

    /**
     * @description: 是否formData提交
     **/
    boolean formDataPost();

    /**
     * @description: 响应类型
     **/
    Class<T> resClass();

    /**
     * @description: 转换实际请求对象
     **/
    Object parseRequest();
}
