package com.jhscale.network.entity.food.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description:
 * @date 2023/7/19 9:10
 */
@ApiModel
@Data
public class UploadFoodPrice implements Serializable {
    @ApiModelProperty(notes = "原系统记录ID", required = true)
    private String itemId;

    @ApiModelProperty(notes = "企业统一社会信用代码", required = true)
    private String socialCreditCode;

    @ApiModelProperty(notes = "企业名称", required = true)
    private String compName;

    @ApiModelProperty(notes = "上报日期（yyyy-MM-dd）", required = true)
    private String reportDate;

    @ApiModelProperty(notes = "原系统商品名称", required = true)
    private String selfCommondityName;

    @ApiModelProperty(notes = "平均价格；元/公斤", required = true)
    private BigDecimal avgPrice;
    //
    @ApiModelProperty(notes = "标准品名")//零售标准品名定义列表_20221215(1).xlsx
    private String standardCommondityName;

    @ApiModelProperty(notes = "最低价格；元/公斤")
    private BigDecimal minPrice;

    @ApiModelProperty(notes = "最高价格；元/公斤")
    private BigDecimal maxPrice;

    @ApiModelProperty(notes = "零售量---金额")
    private BigDecimal amount;

    @ApiModelProperty(notes = "零售总重量；公斤", required = true)
    private BigDecimal weight;

    @ApiModelProperty(notes = "包装方式")
    private String packageName;

    @ApiModelProperty(notes = "包装系数")
    private String packageUnitConversion;

}
