package com.jhscale.network.entity.food.req;

import com.jhscale.network.entity.food.AbstractMarketRequest;
import com.jhscale.network.entity.food.res.UploadFoodPriceLoginResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description: 2.2获取系统访问Token
 * @date 2023/7/19 9:09
 */
@NoArgsConstructor
@ApiModel
@Data
public class UploadFoodPriceLoginRequest extends AbstractMarketRequest<UploadFoodPriceLoginResponse> {

    @ApiModelProperty(notes = "用户名", required = true)
    private String username;

    @ApiModelProperty(notes = "密码", required = true)
    private String password;

    public UploadFoodPriceLoginRequest(String marketId, String username, String password) {
        setMarketId(marketId);
        this.username = username;
        this.password = password;
    }

    /**
     * @description: URL 地址
     **/
    @Override
    public String url() {
        return "https://pre-register.zhuisuyun.net/food-monitor-api/food-monitor-api/token/grant";
    }


    /**
     * @description: 响应类型
     **/
    @Override
    public Class<UploadFoodPriceLoginResponse> resClass() {
        return UploadFoodPriceLoginResponse.class;
    }

    /**
     * @description: 是否formData提交
     **/
    @Override
    public boolean formDataPost() {
        return true;
    }

    //    @Override
//    public String url() {
//        return "https://sapi.jhscale.net/sso-bus/token/login";
//    }
//
//    /**
//     * @description: 响应类型
//     **/
//    @Override
//    public Class<UploadFoodPriceLoginResponse> resClass() {
//        return UploadFoodPriceLoginResponse.class;
//    }
//
//    @ApiModelProperty(notes = "用户名", required = true)
//    private String account;
//
//    @ApiModelProperty(notes = "密码", required = true)
//    private String password;
//
//    @ApiModelProperty(notes = "密码", required = true)
//    private String userType;

}
