package com.jhscale.network.entity.food.req;

import com.jhscale.network.entity.food.AbstractMarketRequest;
import com.jhscale.network.entity.food.res.UploadFoodPriceResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description: 2.3零售信息上报
 * @date 2023/7/19 9:08
 */
@NoArgsConstructor
@ApiModel
@Data
public class UploadFoodPriceRequest extends AbstractMarketRequest<UploadFoodPriceResponse> {

    @ApiModelProperty(notes = "上传商品列表")
    private List<UploadFoodPrice> list;

    public UploadFoodPriceRequest(String marketId, List<UploadFoodPrice> list) {
        setMarketId(marketId);
        this.list = list;
    }

    /**
     * @description: URL 地址
     **/
    @Override
    public String url() {
        return "https://pre-register.zhuisuyun.net/food-monitor-api/food-monitor-api/collect/retail/uploadRetailData";
    }

    /**
     * @description: 响应类型
     **/
    @Override
    public Class<UploadFoodPriceResponse> resClass() {
        return UploadFoodPriceResponse.class;
    }

    @Override
    public Object parseRequest() {
        return getList();
    }
}
