package com.jhscale.network.entity.food.res;

import com.jhscale.network.entity.food.BaseMarketResponse;
import com.ysscale.framework.utils.JSONUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.jhscale.network.client.UploadFoodPriceClient.SUCCESS_CODE;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description:
 * @date 2023/7/19 9:09
 */
@ApiModel
@Data
public class UploadFoodPriceLoginResponse implements BaseMarketResponse {
    @ApiModelProperty(notes = "响应信息", example = "操作成功")
    private String msg;
    @ApiModelProperty(notes = "响应编码", example = "200")
    private Integer code;
    @ApiModelProperty(notes = "响应token", example = "eyJhbGciOiJIUzI1NiJ9.eyJqdGkiOiI4ODgiLCJzdWIiOiLlsI_nmb0iLCJpYXQiOjE1MjM0MTY1NjksImV4cCI6MTUyMzQxNjYyOX0.Tk91b6mvyjpKcldkic8DgXz0zsPFFnRgTgkgcAsa9cc")
    private String token;

    /**
     * @description: 解析token
     **/
    public UploadFoodTokenInfo parseToken() {
        if (code != 200) {
            throw new RuntimeException("登录失败 " + JSONUtils.objectToJson(this));
        }
        return UploadFoodTokenInfo.parseToken(token);
    }

    public boolean result() {
        return Integer.valueOf(SUCCESS_CODE).equals(this.code);
    }

}
